#ifndef CAPTURE_H
#define CAPTURE_H

// <<< Use Configuration Wizard in Context Menu >>>

// <h> CAPCONT configuration
	// <e> External Capture Enable/Disable
		#define E_CAPTURE_MODE 1
	// <i> If selected, INT_CAP_IN does not to be set
	// </e>
	
	// <o.0..2> CAPCKS  <0=> 48MHz/4  <1=> 48MHz/8  <2=> 48MHz/16  <3=> 48MHz/32  <4=> 48MHz/64  <5=> 48MHz/128  <6=>  48MHz/256  <7=> 48MHz/512 
	#if (E_CAPTURE_MODE==1)
		// <o.4> CAPPINSEL(External) <0=> CAP2/P0_7/Data 0 Input <1=> CAP1/P0_6/Data 1 Input
	#else
		// <o.4> INT_CAP_IN(Internal) <0=> Data 0 input <1=> Data 1 input
	#endif
	// <o.7> CAP_EN <0=> Disable <1=> Enable 
		#define CAPCONT_REGS 0x97
// </h>

// <<< end of configuration section >>>

//#if ((CAPCONT_REGS & 0x07) == 0x00)
//#define SPEED_VALUE ((((uint32)48000000/4)*60)/POLE_PAIRS)
//#endif
//#if ((CAPCONT_REGS & 0x07) == 0x01)
//#define SPEED_VALUE ((((uint32)48000000/8)*60)/POLE_PAIRS)
//#endif
//#if ((CAPCONT_REGS & 0x07) == 0x02)
//#define SPEED_VALUE ((((uint32)48000000/16)*60)/POLE_PAIRS)
//#endif
//#if ((CAPCONT_REGS & 0x07) == 0x03)
//#define SPEED_VALUE ((((uint32)48000000/32)*60)/POLE_PAIRS)
//#endif
//#if ((CAPCONT_REGS & 0x07) == 0x04)
//#define SPEED_VALUE ((((uint32)48000000/64)*60)/POLE_PAIRS)
//#endif
//#if ((CAPCONT_REGS & 0x07) == 0x05)
//#define SPEED_VALUE ((((uint32)48000000/128)*60)/POLE_PAIRS)
//#endif
//#if ((CAPCONT_REGS & 0x07) == 0x06)
//#define SPEED_VALUE ((((uint32)48000000/256)*60)/POLE_PAIRS)
//#endif
//#if ((CAPCONT_REGS & 0x07) == 0x07)
//#define SPEED_VALUE ((((uint32)48000000/512)*60)/POLE_PAIRS)
//#endif

#if ((CAPCONT_REGS & 0x07) == 0x00)
#define SPEED_VALUE ((((uint32)48000000/4)*60))
#endif
#if ((CAPCONT_REGS & 0x07) == 0x01)
#define SPEED_VALUE ((((uint32)48000000/8)*60))
#endif
#if ((CAPCONT_REGS & 0x07) == 0x02)
#define SPEED_VALUE ((((uint32)48000000/16)*60))
#endif
#if ((CAPCONT_REGS & 0x07) == 0x03)
#define SPEED_VALUE ((((uint32)48000000/32)*60))
#endif
#if ((CAPCONT_REGS & 0x07) == 0x04)
#define SPEED_VALUE ((((uint32)48000000/64)*60))
#endif
#if ((CAPCONT_REGS & 0x07) == 0x05)
#define SPEED_VALUE ((((uint32)48000000/128)*60))
#endif
#if ((CAPCONT_REGS & 0x07) == 0x06)
#define SPEED_VALUE ((((uint32)48000000/256)*60))
#endif
#if ((CAPCONT_REGS & 0x07) == 0x07)
//#define SPEED_VALUE ((((uint32)48000000/512)*60))

//#define SPEED_VALUE ((uint32)5625000 >> AngleBaseShift)
//#define SPEED_VALUE ((uint32)((float)5625000 * 4096/BASE_RPM))
#define SPEED_VALUE ((uint32)((float)93750 * 120 * 32768/(POLE)/(BASE_RPM)))
#define FREQ_VALUE ((uint32)2298000) //24.512 * 48000000/512
#endif
//RealRpm = (long)11250000 / RotorSpeedTemp;

//#define BEMF_MACRO(v) v = SPEED_VAL / v

extern unsigned int CaptureTotal;
extern unsigned int CaptureTotalTemp;

extern void EXCAP_Init (void);
extern void CAP_Init (void);
#endif